---
title: Lecture 48：正项级数
tags:
  - 数学
  - 正项级数
categories: 
date: 2024-02-13
---
---
## 48.1 正项级数
### 48.1.1 正项级数的定义
##### **定理**： #正项级数的收敛性
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>正项 $\sum u_n$ 收敛的充分必要条件是 ${S_n}$ 有界；
> 即：$$\sum_{n=1}^\infty u_n\text{ 收敛}\Leftrightarrow s_n\text{ 上有界}$$

**正向级数的概念**
+ $u_n$ 的每一项都大于 0；
+ 并且因为正向技术的每一项都是正的，所以和是递增的：
	+ $S_{1}\leq S_{2}\leq S_{3}\cdots$ `->` $\{S_{n}\}\geq0$

**解释**
+ 但这个定理几乎没什么用 -> 因为很难判断 $S_n$ 是否有界；


### 48.1.2 方法选择
**方法**
+ 方法分类：
	+ 1. 比较审敛法 
	+ 2. 比较法的极限形式 
	+ 3. 比值法 
	+ 4. 根值法
	+ 5. 积分判别法 
+ 方法选择：
	+ 第一类：方法 `1、2`
		+ 需要把当前的通项和其它已知通项进行比较；
		+ 优点： 
			+ 适用范围更广泛；
			+ 只要是方法 3、4 可以做出判定的，方法 1、2 都一定可以做出判定，只是可能做起来更不方便；
		+ 缺点： 
			+ 使用起来不方便；
	+ 第二类：方法 `3、4`
		+ 概念： 
			+ 只需要自己就可以进行判断；
		+ 优点： 
			+ 使用起来方便，不需要其他级数，自己就可以判断；
		+ 缺点： 
			+ 有些时候，级数很明显可以看出来时发散的，但却很难用方法证明出来；
			+ 即：适用范围窄；
+ 解题步骤：
	+ 1. 先观察是否可以直接看出来敛散性 `->` 规律； 
	+ 2. 在判断方法时，先考虑使用方法 `3、4`；
	+ 3. 如果做不出判定，再考虑 `1、2`；
+ 规律： 
	+ 三巨头：$$a^n\quad n!\quad n^n$$
	+ 如果这三巨头当中至少出现一个，通常就使用方法 `3、4`；
	+ 如果三巨头一个都不出现，此时经常出现的就是 $n^p$ 或者 $In{n}$ 的形式，此时就使用方法 `1、2`；

## 48.2 比较审敛法
### 48.2.1 比较审敛法定义
**从问题开始**
+ 1. 如何对不等式放缩？ `->` 应该是放、还是缩？
+ 2. 和谁来比？
+ 思路：
	+ 用极限来改进的比较审敛法；

##### **定理**： #比较审敛法 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $\sum U_n$ 和 $\sum V_n$ 都是正项级数，且 $u_n<v_n$：
> $$\sum_{n=1}^\infty\nu_n\text{ 收敛 }\Rightarrow\sum_{n=1}^\infty u_n\text{ 收敛}$$
> $$\sum_{n=1}^\infty u_n\text{ 发散 }\Rightarrow\sum_{n=1}^\infty\nu_n\text{发散}$$

**解释**
+ 总结：
	+ 大的收敛，小的肯定收敛；
	+ 小的发散，大的肯定发散；
	+ 反过来都不行；
+ 使用方法：
	+ 使用之前，先进行初步判断；
	+ 如果初步判断其为收敛，则进行放大；
	+ 如果初步判断其为发散，将进行缩小；
+ 使用前提：
	+ 两个级数都是**正项级数**；

**补充**
+ 第一种情况时
	+ 如果 L 等于 0 `->` Un 是比 Vn 更高级的无穷小，Vn 趋向于 0 的速度更快；
	+ 如果 L 大于零且小于正无穷（即为常数），则此时 Un 和 Vn 是同阶的无穷小；
	+ 如果 L 等于正无穷 `->` 则 Un 无法判断，且 Un 是 Vn 的低阶无穷小；
+ 第二种情况时
	+ 如果 L 大于 0 `->` Un 发散，Vn 也跟着发散；
	+ 如果 Un 比 Vn 是正无穷，则发散性也一致，Un 是 Vn 的低阶无穷小；
	+ 如果 L 等于 0 时 `->` 如果 Vn 是发散的，则 Un 也无法判断；
+ 问题：还是得和一个 $V_n$ 来和目标函数比较，进而判断其敛散性；

**和谁比**
+ 核心问题：
	+ 怎么找用于辅助判断的级数 `->` 两个常用级数；


### 48.2.2 比较法的极限形式
##### **定理**： #比较法极限形式 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>设 $$\lim_{n\to\infty}\frac{u_n}{v_n}=l\left(0\leq l\leq+\infty\right)$$
> 若：
> 1. $$若0<l<+\infty,\text{则}\sum_{n=1}^{\infty}u_{n}与\sum_{n=1}^{\infty}\nu_{n}{\text{同敛散}.}$$
> 2. $$\text{若 }l=0\text{,则}\sum_{n=1}^\infty\nu_n\text{收敛 }\Rightarrow\sum_{n=1}^\infty u_n\text{ 收敛,}\sum_{n=1}^\infty u_n\text{发散 }\Rightarrow\sum_{n=1}^\infty\nu_n\text{发散}$$
> 3. $$\text{若 }l=+\infty,\text{则}\sum_{n=1}^\infty\nu_n\text{发散}\Rightarrow\sum_{n=1}^\infty u_n\text{ 发散. }\sum_{n=1}^\infty u_n\text{收敛}\Rightarrow\sum_{n=1}^\infty\nu_n\text{ 收敛}$$

**解释**
+ 概念：将两个通项比大小的问题，转化为了求**两个通项之比的极限**的问题；

### 48.2.3 两个常用级数
**常用级数一**：P 级数
+ 公式：
	+ $$\sum_{n=1}^\infty\frac1{n^p}  \quad\quad\quad\quad\quad  P>1时收敛，P<=1时发散$$
+ 注意：
	+ `P=1` `->` 调和级数： $\sum\frac{1}{n}\quad 一定发散$ 
	+ 为什么 P=1 时是发散的？
+ 本质：
	+ 收敛的本质：决定级数是否收敛的不在于求和项是否是无穷的，甚至不在于求和的大小，而是在于求和项中通项趋向于 0 的速度；
	+ 通过速度比较并不能确定一个级数发散还是收敛，但是速度变化会带来本质的变化

**常用级数二**：等比级数
+ 公式：
	+ $$\sum_{n=1}^\infty aq^n\left(a>0,q>0\right)\quad q<1\text{ 时收敛,当 }q\geq1\text{ 时发散}.$$
+ 概念：   
	+ 等比级数是否收敛，只取决于其 `q` 的数值，即公比决定了其敛散性；
	+ 即对于等比级数而言，如果公比 $\frac{u_{u+1}}{u_n}=q$ 存在，则其具有以上极限；

**补充**：调和级数的收敛性
+ $$\sum_{n=1}^{\infty}\frac{1}{n}=1+\frac{1}{2}+\frac{1}{3}+\cdots+\underbrace{\frac{1}{n}+\frac{1}{n+1}+\cdots+\frac{1}{2n-1}}+\cdots$$
+ $$\frac{1}{n}+\frac{1}{n+1}+\cdots+\frac{1}{2n-1}>\underbrace{\frac1{2n}+\frac1{2n}+\cdots+\frac1{2n}}_{n\text{项}}=\frac n{2n}=\frac12$$
+ 调和级数的部分和，可以凑出一个与 `n` 无关的常数与 `n` 无关就意味着，无穷对它失去了意义，所以发散；

## 48.3 比值审敛法
### 48.3.1 比值法
##### **定理**： #比值审敛法 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font>如果 $\sum U_n$ 是一个正项级数，则若 $$\lim_{n\to\infty}\frac{u_{n+1}}{u_{n}}=\rho$$
> 如果 $\rho <1$，则 $\sum U_n$ 收敛；
> 如果 $\rho >1$，则 $\sum U_n$ 发散；
> 如果 $\rho =1$，则 $\sum U_n$ 无法判断，请使用其他方法；

**优缺点**
+ 优点：自己和自己比，不需要找其他的函数；
+ 缺点：如果 $\rho =1$，则方法失效；
 
### 48.3.2 根值法
##### **定理**： #根值法
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\text{设}\lim_{n\to\infty}\sqrt[n]{u_n}=\rho\text{,则}\sum_{n=1}^\infty u_n\begin{cases}\text{收敛},&\rho<1,\\\\\text{发散},&\rho>1,\\\\\text{不一定},&\rho=1,\end{cases}$$

**解释**

## 48.4 积分判别法
##### **定理**： #积分判别法
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$设f(x)在[1,+\infty)上单调减，非负的连续函数，且 a_{n}=f(n)，则\sum_{n=1}^{\infty}a_{n}\text{ 与 }\int_{1}^{+\infty}f(x)dx同敛散性$$

**解释**
+ 用的比较少，因为条件很多；

**例题**：证明级数 $\sum_{i=1}^\infty\frac1{n^p}$ 当 $p>1$ 时收敛，当 $p\leq1$ 时发散.
+ 解析
	+ 设 $a_{n}=\frac{1}{n^{p}}=f(u),f(x)=\frac{1}{x^{p}}$
	+ 所以得到积分：$\int_{1}^{+\infty}\frac{dx}{x^{p}}$


## 48.5 例题
**例题**：$\sum\frac{1}{\sqrt{n(n+1)}}$ 求其发散性质
+ 分析
+ 解析
	+ $因为：n(n+1)<(n+1)^{2}$；
	+ 所以： $\frac{1}{\sqrt{n(n+1)}}>\frac{1}{\sqrt{(n+1)^{2}}}=\frac{1}{n+1}$
+ 题型： #正项级数 

**例题**：求 $\sum_{n=1}^{\infty}\sin\frac{1}{n}$ 的敛散性
+ 分析
	+ 首先：sin 1/n 一定是正的数；
+ 解析
	+ 因为 $\lim_{n\to\infty}\frac{\sin{\frac{1}{n}}}{\frac{1}{n}}=1$，其极限为 0/0 型，最后结果为 1；
	+ 所以 1>0，所以 $\sin{\frac{1}{n}}$ 和 $\frac{1}{n}$ 是同阶的； 
	+ 因为 $\sum\frac{1}{n}发散 ，所以\sum\sin{\frac{1}{n}}发散$
+ 题型： #比较审敛法

**例题**：$1+\frac{1}{1}+\frac{1}{2!}+\frac{1}{3!}+\cdots+\frac{1}{(n-1)!}+\cdots$，证明它是收敛的；
+ 分析
+ 证明
	+  因为 $\lim_{n\to\infty}\frac{u_{n+1}}{u_{n}}=\lim_{n\to\infty}\frac{\frac{1}{n^{1}}}{\frac{1}{\left(n-n\right)!}}=\lim_{n\to\infty}\frac{1}{n}=0<1$，所以其收敛；
	+ 
+ 题型： #比值审敛法 